#pragma once
#include "../mesh/Mesh.h"
#include <vector>

class VoxelGenerator {
public:
    VoxelGenerator(int sizeX, int sizeY, int sizeZ);

    void setVoxel(int x, int y, int z, bool value);
    bool getVoxel(int x, int y, int z) const;

    Mesh generateMesh(float voxelSize = 1.0f);
    void relaxMesh(Mesh& mesh, int iterations, float factor);

    void fillSphere(const Vec3& center, float radius);
    void fillBox(const Vec3& min, const Vec3& max);
    void fillFromMesh(const Mesh& mesh, float voxelSize = 1.0f);

private:
    int sizeX, sizeY, sizeZ;
    std::vector<bool> voxels;

    int getIndex(int x, int y, int z) const;
    bool isValidCoord(int x, int y, int z) const;
};
