#pragma once
#include <vector>
#include <functional>

class NSGAIIOptimizer {
public:
    using ObjectiveFunction = std::function<std::vector<double>(const std::vector<double>&)>;

    struct Individual {
        std::vector<double> variables;
        std::vector<double> objectives;
        int rank;
        double crowdingDistance;
    };

    NSGAIIOptimizer(int dimension, int numObjectives);

    std::vector<Individual> optimize(ObjectiveFunction func, int maxGenerations = 100);

    void setPopulationSize(int size) { populationSize = size; }
    void setBounds(const std::vector<double>& lower, const std::vector<double>& upper);

private:
    int dimension;
    int numObjectives;
    int populationSize;
    std::vector<double> lowerBounds;
    std::vector<double> upperBounds;

    void fastNonDominatedSort(std::vector<Individual>& population);
    void calculateCrowdingDistance(std::vector<Individual>& front);
    bool dominates(const Individual& a, const Individual& b);
};
