#pragma once
#include <vector>
#include <functional>

class NeuralNetwork {
public:
    NeuralNetwork(const std::vector<int>& layerSizes);

    std::vector<double> forward(const std::vector<double>& input);
    void train(const std::vector<std::vector<double>>& inputs,
               const std::vector<std::vector<double>>& targets,
               int epochs, double learningRate);

    void setActivationFunction(std::function<double(double)> func) { activation = func; }

private:
    std::vector<int> layerSizes;
    std::vector<std::vector<std::vector<double>>> weights;
    std::vector<std::vector<double>> biases;
    std::function<double(double)> activation;

    void backpropagate(const std::vector<double>& input,
                       const std::vector<double>& target,
                       double learningRate);
    double sigmoid(double x);
    double sigmoidDerivative(double x);
};
