#pragma once
#include "../mesh/Mesh.h"
#include <string>

class MeshExporter {
public:
    // Export mesh to various formats based on file extension
    static bool exportMesh(const std::string& filepath, const Mesh& mesh);

    // Format-specific exporters
    static bool exportOBJ(const std::string& filepath, const Mesh& mesh);
    static bool exportSTL(const std::string& filepath, const Mesh& mesh);
    static bool exportPLY(const std::string& filepath, const Mesh& mesh);
    static bool exportJSON(const std::string& filepath, const Mesh& mesh);
    static bool exportX3D(const std::string& filepath, const Mesh& mesh);
    static bool exportWRL(const std::string& filepath, const Mesh& mesh);
    static bool exportDXF(const std::string& filepath, const Mesh& mesh);
    static bool export3DS(const std::string& filepath, const Mesh& mesh);

private:
    static std::string getFileExtension(const std::string& filepath);
    static std::string toLower(const std::string& str);
};
