#pragma once
#include "../mesh/Mesh.h"
#include <vector>
#include <map>

struct KeyFrame {
    float time;
    std::vector<Vec3> positions;

    KeyFrame(float t) : time(t) {}
};

class VertexAnimator {
public:
    VertexAnimator();

    void addKeyFrame(float time, const Mesh& mesh);
    void applyAnimation(Mesh& mesh, float time);

    void setLooping(bool loop) { looping = loop; }
    void setDuration(float dur) { duration = dur; }

    float getDuration() const { return duration; }
    size_t getKeyFrameCount() const { return keyFrames.size(); }

    // Procedural animation methods
    void animateWave(Mesh& mesh, float time, float amplitude, float frequency);
    void animateTwist(Mesh& mesh, float time, float amount);
    void animateBend(Mesh& mesh, float time, float amount);
    void animatePulse(Mesh& mesh, float time, float scale);
    void animateNoise(Mesh& mesh, float time, float intensity);

private:
    std::vector<KeyFrame> keyFrames;
    bool looping;
    float duration;

    Vec3 interpolate(const Vec3& a, const Vec3& b, float t);
    int findKeyFrameIndex(float time);
};
