#pragma once
#include "AlgorithmLibrary.h"

namespace ExtendedAlgorithms {

    enum ExtendedAlgorithmType {
        // Primitives (continue from existing)
        PRIMITIVE_SPHERE = 100,
        PRIMITIVE_CUBE,
        PRIMITIVE_TORUS,
        PRIMITIVE_CYLINDER,
        PRIMITIVE_CONE,
        SUPERELLIPSOID,
        SUPERTOROID,

        // Minimal Surfaces
        NEOVIUS_SURFACE,
        HELICOID_SURFACE,
        CATENOID_SURFACE,
        ENNEPER_SURFACE,

        // Topology
        KNOT_FIGURE_EIGHT,

        // Organic/Shells
        SHELL_NAUTILUS,
        SHELL_CONCH,

        // Fractals
        FRACTAL_TREE,
        FRACTAL_MOUNTAIN,
        FRACTAL_FERN,
        FRACTAL_MANDELBULB,
        FRACTAL_MENGER,
        JULIA_SET_3D,
        DRAGON_CURVE,
        HILBERT_CURVE,

        // Platonic Solids
        PLATONIC_TETRAHEDRON,
        PLATONIC_OCTAHEDRON,
        PLATONIC_ICOSAHEDRON,
        PLATONIC_DODECAHEDRON,
        GEODESIC_SPHERE,

        // Parametric Curves
        PARAMETRIC_WAVES,
        PARAMETRIC_SPRING,
        PARAMETRIC_TREFOIL,
        LISSAJOUS_CURVE,
        ROSE_CURVE,
        SEASHELL_CURVE,
        HEART_CURVE,
        HELIX_CURVE,

        // Mechanical
        GEAR_INVOLUTE,

        // Deformations
        TWISTED_BOX,
        BENT_CYLINDER,
        TAPERED_CYLINDER,

        // Organic Forms
        FLOWER_PROCEDURAL,
        CRYSTAL_STRUCTURE,
        TENTACLE,

        // Computational
        VORONOI_SURFACE,
        DELAUNAY_SURFACE,
        PIPE_NETWORK,
        BUILDING_PARAMETRIC,
        LATTICE_STRUCTURE,
        DIAMOND_LATTICE,

        // Modifiers
        MOD_SCALE,
        MOD_TRANSLATE,
        MOD_ROTATE,
        MOD_PERLIN_NOISE,
        MOD_SMOOTH,
        MOD_INFLATE,
        MOD_SOLIDIFY,
        MOD_SUBDIVIDE,
        MOD_DECIMATE,
        MOD_TWIST_DEFORM,
        MOD_BEND_DEFORM,
        MOD_TAPER_DEFORM,
        MOD_WAVE_DEFORM,
        MOD_SPHERIFY,
        MOD_LATTICE_DEFORM,
        MOD_MIRROR,
        MOD_ARRAY,
        MOD_SHELL,
        MOD_DISPLACE,
        MOD_REMESH,
        MOD_EXTRUDE
    };

    struct AlgorithmInfo {
        std::string category;
        std::string name;
        std::string description;
    };

    std::map<int, AlgorithmInfo> getAllAlgorithmInfo();
}
